<?php

include ("../serive/samparka.php");

// F2Pay platform public key (PEM format)
$platformPublicKey = "-----BEGIN PUBLIC KEY-----\n" .
    wordwrap("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2YC5ccCiPGsAWpn4d1lCCl/sGzZkZ56zLJOFgKQmYagdZK6Oe3UErWc2C6pe71sIkd6i0tHnEeA0wch5wg0c4j7dYhZ0e/Pb4usMjr8oBVsSmpXH9Gf2/+YPoVHvyAdxnvL3n//MpPmSaG9qXE7/OjofIcxmK58mjrvyWcwIyqS6sXKA9O+8plK2nALJ+XXD1VX1bg2D0tNnym3yE7lEFUZ0ShDWsxBIR8nwtXhFNKRQBYUfPFa6nc7YiHu80TW9WnFEIx2b31XsV0jRkhPwcqxyW7h6yY2UnzNqEfTIUeZNDgnMotuL0EFFpIU2jikm1KGFeNG2b6dZlsgiHu6roQIDAQAB", 64, "\n", true) .
    "\n-----END PUBLIC KEY-----";

// Function to log errors
function logError($message) {
    file_put_contents('log.txt', date('Y-m-d H:i:s') . " - " . $message . "\n", FILE_APPEND);
}

// Read and decode JSON POST body
$raw = file_get_contents('php://input');
logError("Received raw: " . $raw);
$data = json_decode($raw, true);

if (!$data) {
    logError("Invalid JSON");
    http_response_code(400);
    exit;
}

// Extract fields
$code = $data['code'] ?? '';
$msg = $data['msg'] ?? '';
$sign = $data['sign'] ?? '';
$bizContentStr = $data['bizContent'] ?? '';
$sysTime = $data['sysTime'] ?? '';

// Verify signature
$publicKeyResource = openssl_pkey_get_public($platformPublicKey);
if (!$publicKeyResource) {
    logError("Invalid platform public key");
    http_response_code(500);
    exit;
}
$signatureValid = openssl_verify($bizContentStr, base64_decode($sign), $publicKeyResource, OPENSSL_ALGO_SHA256) === 1;
if (!$signatureValid) {
    logError("Signature verification failed");
    http_response_code(400);
    exit;
}

// Parse bizContent JSON
$bizContent = json_decode($bizContentStr, true);
if (!$bizContent) {
    logError("Invalid bizContent JSON");
    http_response_code(400);
    exit;
}

// Extract order info
$orderNumber = $bizContent['mchOrderNo'] ?? null;
$amount = $bizContent['amount'] ?? null;
$status = $bizContent['state'] ?? null;

// Validate required parameters
if (!$orderNumber || !$amount || !$status) {
    logError("Missing required parameters");
    http_response_code(400);
    exit;
}

// Reward calculation function (same as before)
function getRewardAmount($rechargeAmount) {
    $rewardTiers = [
        ['amount' => 100000, 'reward' => 8100],
        ['amount' => 50000, 'reward' => 4100],
        ['amount' => 10000, 'reward' => 1100],
        ['amount' => 5000, 'reward' => 600],
        ['amount' => 3000, 'reward' => 400],
        ['amount' => 1000, 'reward' => 200],
        ['amount' => 500, 'reward' => 150],
        ['amount' => 300, 'reward' => 50]
    ];
    foreach ($rewardTiers as $tier) {
        if ($rechargeAmount >= $tier['amount']) {
            return $tier['reward'];
        }
    }
    return 0;
}

// Only process if code is "0000" and state is "Paid"
if ($code === '0000' && $status === 'Paid') {
    $checkamt = mysqli_query($conn, "SELECT t.motta, t.balakedara, t.sthiti, 
        (SELECT COUNT(*) FROM thevani WHERE balakedara = t.balakedara AND sthiti = '1') as recharge_count,
        (SELECT code FROM shonu_subjects WHERE id = t.balakedara) as referrer_code
        FROM thevani t 
        WHERE t.dharavahi = '".$orderNumber."' AND t.sthiti = '0'");

    if (!$checkamt) {
        logError("Database query error: " . mysqli_error($conn));
        exit;
    }

    $checkamtrow = mysqli_num_rows($checkamt);

    if ($checkamtrow >= 1) {
        $checkamtar = mysqli_fetch_array($checkamt);
        $motta = $checkamtar['motta'];
        $shonuid = $checkamtar['balakedara'];
        $recharge_count = $checkamtar['recharge_count'];
        $referrer_code = $checkamtar['referrer_code'];

        // Update user's balance
        $nabikarana = "UPDATE shonu_kaichila 
                       SET motta = ROUND(motta + '".$motta."', 2) 
                       WHERE balakedara = '".$shonuid."'";
        if (!$conn->query($nabikarana)) {
            logError("Database update error: " . mysqli_error($conn));
            exit;
        }

        // If this is user's first recharge, process referral bonus
        if ($recharge_count == 0 && $referrer_code) {
            $reward_amount = getRewardAmount($motta);
            if ($reward_amount > 0) {
                $referrer_query = "SELECT id FROM shonu_subjects WHERE owncode = '".$referrer_code."'";
                $referrer_result = $conn->query($referrer_query);
                if ($referrer_row = mysqli_fetch_array($referrer_result)) {
                    $referrer_id = $referrer_row['id'];
                    $referrer_update = "UPDATE shonu_kaichila 
                                      SET motta = ROUND(motta + '".$reward_amount."', 2) 
                                      WHERE balakedara = '".$referrer_id."'";
                    if (!$conn->query($referrer_update)) {
                        logError("Referral bonus update error: " . mysqli_error($conn));
                    } else {
                        $bonus_log = mysqli_query($conn, "INSERT INTO vyavahara 
                            (balakedara, ketebida, prakara, ayoga, koduvavanu, tiarikala) 
                            VALUES 
                            ('".$referrer_id."', '".$motta."', 'REFERRAL_BONUS', '".$reward_amount."', 
                             '".$shonuid."', '".date('Y-m-d H:i:s')."')");
                        if (!$bonus_log) {
                            logError("Referral bonus log error: " . mysqli_error($conn));
                        }
                    }
                }
            }
        }

        // Update order status
        $sql2 = mysqli_query($conn, "UPDATE thevani SET sthiti = '1' WHERE dharavahi = '".$orderNumber."'");
        if (!$sql2) {
            logError("Order status update error: " . mysqli_error($conn));
            exit;
        }
    }
}

echo "OK";
exit;